#ifndef PHYS_X_TERRAIN_WRAPPER_INCLUDED
#define PHYS_X_TERRAIN_WRAPPER_INCLUDED

#include "i_pathengine.h"
#include <vector>

class NxHeightFieldShape;
class cCoordinateMapping;

class cPhysXTerrainWrapper : public iFaceVertexMesh
{
    int32_t _stride, _strides;
    std::vector<int32_t> _pointCoords;
    std::vector<bool> _tessellationFlags;
    std::vector<int32_t> _holesRemap;

public:

    cPhysXTerrainWrapper(const NxHeightFieldShape& heightFieldShape, const cCoordinateMapping& coordinateMapping, float scale);

// iFaceVertex interface

    int32_t faces() const;
    int32_t vertices() const;
    int32_t vertexIndex(int32_t face, int32_t vertexInFace) const;
    int32_t vertexX(int32_t vertex) const;
    int32_t vertexY(int32_t vertex) const;
    float vertexZ(int32_t vertex) const;
    int32_t faceAttribute(int32_t face, int32_t attributeIndex) const;
};

#endif
